package ie.ucd.sixth.adaptor.database;

import ie.ucd.sixth.core.adaptor.IAdaptor;
import ie.ucd.sixth.core.databroker.CoreDataBroker;
import ie.ucd.sixth.core.notification.INotifiable;
import ie.ucd.sixth.core.notification.INotifier;
import ie.ucd.sixth.core.receiver.IDataReceiver;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {

	private static BundleContext context;
	//private IAdaptor adaptor;
	private IDataReceiver receiver;
	private INotifiable notifiable;
	//private Notifiable notifi;

	static BundleContext getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		Activator.context = bundleContext;
		receiver = new DataReceiver(context);
		notifiable = new DataNotifiable(context);
		
		//ServiceTracker for CoreDataBroker
//		CoreDataBroker broker;
//		broker.registerInterest(new AllQuery(), receiver);
		//adaptor = new DatabaseAdaptor(bundleContext);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		Activator.context = null;
		receiver.unregister();
		for(INotifier notifier : notifiable.getNotifiers())notifier.unregister();
		//adaptor.unregister();
	}

}
